$(document).ready(function () {
  const subscribeButton = document.querySelector('.subscribe-button');
  const subscribeOverlay = document.querySelector('.subscribe-overlay');
  const subscribeFormContainer = document.querySelector('.subscribe-form-container');
  const closeFormButton = document.querySelector('.close-form-button');
  const hubspotFormDiv = document.querySelector('.hbspt-form');

  // Check if subscribe elements exist before adding event listeners
  if (subscribeButton && subscribeOverlay && subscribeFormContainer && closeFormButton) {
    subscribeButton.addEventListener('click', function () {
      subscribeOverlay.style.display = 'block';
      subscribeFormContainer.style.display = 'block';
    });

    subscribeOverlay.addEventListener('click', function () {
      subscribeOverlay.style.display = 'none';
      subscribeFormContainer.style.display = 'none';
    });

    closeFormButton.addEventListener('click', function () {
      subscribeOverlay.style.display = 'none';
      subscribeFormContainer.style.display = 'none';
    });
  }

  // Check if the HubSpot form div exists before observing
  if (hubspotFormDiv) {
    // Create a MutationObserver to monitor changes in the hbspt-form div
    const observer = new MutationObserver(function (mutationsList) {
      for (const mutation of mutationsList) {
        if (mutation.addedNodes.length > 0) {
          // Check if the submitted-message div has been added
          mutation.addedNodes.forEach((node) => {
            if (node.nodeType === 1 && node.classList.contains('submitted-message')) {
              const formHeading = document.querySelector('.subscribe-form__heading');
              const formSubtitle = document.querySelector('.subscribe-form__subtitle');
              const submittedImg = document.querySelector('.submitted-img');
              const closeFormBtn = document.querySelector('.close-form-button');
              const subscribeModal = document.querySelector('.subscribe-modal');

              if (formHeading && formSubtitle && submittedImg && closeFormBtn && subscribeModal) {
                formHeading.innerText = 'Thank you';
                formSubtitle.innerHTML = 'You are now subscribed to <strong> GoodData’s Updates.</strong>';
                submittedImg.style.display = 'block';
                closeFormBtn.style.backgroundImage = 'url(/icons/x-close-forms-white.svg)';
                subscribeModal.style.padding = '0';
              }
            }
          });
        }
      }
    });

    // Observe the hbspt-form div for changes
    observer.observe(hubspotFormDiv, { childList: true, subtree: true });
  }
});
