document.addEventListener("DOMContentLoaded", () => {
    const increment = 10;
    const hideClass = "d-none";
    const divs = Array.from(document.getElementsByClassName("release-note__section"));
    const showMoreBtn = document.getElementById("showMoreBtn");

    if(divs.length > increment) {
        if(!window.location.hash) {
            divs.slice(increment).forEach(div => div.classList.add(hideClass));
            showMoreBtn.addEventListener("click", showMoreDivs);
        } else {
            hideButton();
            showLink();
        }

        function showMoreDivs() {
            showDivs();
        }

        function showDivs() {
            const hidden = divs.filter(div => div.classList.contains(hideClass));

            if(hidden.length > 0) {
                hidden.slice(0, increment).forEach(div => div.classList.remove(hideClass));
            } 

            if(hidden.length <= increment) {
                hideButton();
                allReleasesLink.classList.remove(hideClass);
            }
        }

        function hideButton() {
            showMoreBtn.classList.add(hideClass);
        }

        function showLink() {
            document.getElementById("allReleasesLink").classList.remove(hideClass);
        }
    }
});
